﻿using System;
using System.ComponentModel;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Menu.Sample3
{
    public partial class FormMain : Form
    {
        public const int MF_Checked = 0x8;
        public const int MF_Disabled = 0x2;
        public const int MF_Grayed = 0x1;
        public const int MF_Separator = 0x800;
        public const int MF_String = 0x0;
        public const int MF_Enabled = 0x0;

        [DllImport("user32.dll")]
        public static extern IntPtr GetMenuItemID(IntPtr hMenu, int nPosition);

        [DllImport("user32.dll", SetLastError = true)]
        public static extern bool ModifyMenu(IntPtr hMnu, IntPtr uPosition, int uFlags, IntPtr uIDNewItem, string lpNewItem);

        [DllImport("user32.dll")]
        public static extern IntPtr GetSystemMenu(IntPtr hwnd, bool bRevert);

        public FormMain()
        {
            InitializeComponent();
        }

        private void FormMain_Load(object sender, System.EventArgs e)
        {
        }

        private void buttonChange_Click(object sender, EventArgs e)
        {
            IntPtr hSystemMenu = GetSystemMenu(this.Handle, false);
            if (hSystemMenu == IntPtr.Zero) return;
            // minimize item position is 3
            IntPtr minimizeItemId = GetMenuItemID(hSystemMenu, 3);
            // close item position is 6
            IntPtr closeItemId = GetMenuItemID(hSystemMenu, 6);

            bool result = ModifyMenu(hSystemMenu, closeItemId, MF_Checked | MF_Enabled | MF_String, minimizeItemId, "Close");
            if (result == false)
            {
                Win32Exception ex = new Win32Exception();
                MessageBox.Show(ex.Message, "Last Error!", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}